/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.recipe.EnchantalCoolerRecipe;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PillagerKnifeAddPotionRecipe
extends EnchantalCoolerRecipe {
    public PillagerKnifeAddPotionRecipe(NonNullList<Ingredient> ingredient, ItemStack output, ItemStack container, ResourceLocation id) {
        super(ingredient, new ItemStack((ItemLike)ImmortalersDelightItems.PILLAGER_KNIFE.get()), new ItemStack((ItemLike)ImmortalersDelightItems.PILLAGER_KNIFE.get()), id);
    }

    @Override
    public boolean matches(SimpleContainer inv, Level pLevel) {
        boolean hasPotion = false;
        if (this.getContainer().m_41619_() || this.getContainer().m_150930_(inv.m_8020_(4).m_41720_())) {
            for (int j = 0; j < 4; ++j) {
                ItemStack itemstack = inv.m_8020_(j);
                if (PotionUtils.m_43579_((ItemStack)itemstack) == Potions.f_43598_ && PotionUtils.m_43571_((ItemStack)itemstack).size() <= 0) continue;
                if (hasPotion) {
                    return false;
                }
                hasPotion = true;
            }
        }
        return hasPotion;
    }

    @Override
    @NotNull
    public ItemStack assemble(SimpleContainer pInv, RegistryAccess pRegistryAccess) {
        ItemStack potion = ItemStack.f_41583_;
        ItemStack knife = ItemStack.f_41583_;
        for (int j = 0; j < 4; ++j) {
            ItemStack itemstack = pInv.m_8020_(j);
            if (PotionUtils.m_43579_((ItemStack)itemstack) == Potions.f_43598_ && PotionUtils.m_43571_((ItemStack)itemstack).size() <= 0) continue;
            potion = itemstack;
        }
        if (pInv.m_8020_(4).m_150930_((Item)ImmortalersDelightItems.PILLAGER_KNIFE.get())) {
            knife = pInv.m_8020_(4);
        }
        if (potion.m_41619_() || knife.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack1 = knife.m_41777_();
        PotionUtils.m_43549_((ItemStack)itemstack1, (Potion)PotionUtils.m_43579_((ItemStack)potion));
        PotionUtils.m_43552_((ItemStack)itemstack1, (Collection)PotionUtils.m_43571_((ItemStack)potion));
        if (PotionUtils.m_43571_((ItemStack)potion).isEmpty()) {
            itemstack1.m_41784_().m_128405_("potion_coating_count", 8);
        } else {
            itemstack1.m_41784_().m_128405_("potion_coating_count", 3);
        }
        return itemstack1;
    }

    @Override
    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static class Type
    implements RecipeType<PillagerKnifeAddPotionRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "pillagers_knife_add_potion";
    }

    public static class Serializer
    implements RecipeSerializer<PillagerKnifeAddPotionRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("immortalers_delight", "pillagers_knife_add_potion");

        public PillagerKnifeAddPotionRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122779_();
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            ItemStack container = GsonHelper.m_13900_((JsonObject)pSerializedRecipe, (String)"container") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"container"), (boolean)true) : ItemStack.f_41583_;
            return new PillagerKnifeAddPotionRecipe((NonNullList<Ingredient>)inputs, output, container, pRecipeId);
        }

        @Nullable
        public PillagerKnifeAddPotionRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int ingredientCount = pBuffer.readInt();
            NonNullList inputs = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientCount; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack container = pBuffer.m_130267_();
            ItemStack output = pBuffer.m_130267_();
            return new PillagerKnifeAddPotionRecipe((NonNullList<Ingredient>)inputs, output, container, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PillagerKnifeAddPotionRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.m_7527_().size());
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
            pBuffer.m_130055_(pRecipe.getContainer());
        }
    }
}

